﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" version="1.0" exclude-result-prefixes="msxsl">
  <xsl:output method="xml" indent="yes"/>

  <!-- general container tamplate -->
  <xsl:template match="/MODULES">
    <xsl:for-each select="MODULE">
      <input type="hidden" id="htxtMID" value="{MID}" editable="{EDITABLE}" />
      <!-- Module Title -->
      <div class="container-fluid">
        <div class="page-header">
          <h3>
            <xsl:value-of select="MODULE_TITLE/node()" disable-output-escaping="yes" />
          </h3>
        </div>
        <!-- Iterate Topics -->
        <xsl:for-each select="TOPICS/TOPIC">
          <div id="TID{TID}" class="panel panel-default">
            <div class="panel-heading">
              <h3 class="panel-title">
                <xsl:value-of select="TOPIC/node()" disable-output-escaping="yes" />
              </h3>
            </div>
            <div class="panel-body">
              <!-- Iterate Questions -->
              <xsl:for-each select="QUESTIONS/QUESTION">
                <div id="TID{TID}_QID{QID}" class="question-container" reqd-val="{REQUIRED}" >
                  <h4>
                    <!-- <small>
                      TID<xsl:value-of select="TID"/>_QID<xsl:value-of select="QID"/>
                    </small>&#160; -->
                    <xsl:value-of select="QUESTION/node()" disable-output-escaping="yes" />
                  </h4>

                  <!-- Iterate Responses -->
                  <xsl:choose>

                    <!-- ############################# -->
                    <!-- VERTICAL responses rendering  -->
                    <!-- ############################# -->
                    <xsl:when test="RESPONSES_POS = 1">
                      <xsl:choose>

                        <!-- ############################# -->
                        <!-- use UL tag as the organizer -->

                        <xsl:when test="RESPONSE_LAYOUT = 1">
                          <ul style="list-style: none;">
                            <xsl:apply-templates select="RESPONSES"/>
                          </ul>
                        </xsl:when>

                        <!-- ############################# -->
                        <!-- use TABLE tag as the organizer -->

                        <xsl:otherwise>
                          <table class="tbl-vertical">
                            <xsl:apply-templates select="RESPONSES" mode="tabular_vertical"/>
                          </table>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>

                    <!-- ############################### -->
                    <!-- HORIZONTAL responses rendering  -->
                    <!-- ############################### -->
                    <xsl:otherwise>

                      <xsl:choose>
                        <!-- ############################# -->
                        <!-- use UL tag as the organizer   -->

                        <xsl:when test="RESPONSE_LAYOUT = 1">
                          <ul class="responses-horizontal" style="list-style: none;">
                            <xsl:apply-templates select="RESPONSES" />
                          </ul>
                        </xsl:when>

                        <!-- ############################### -->
                        <!-- use TABLE tag as the organizer   -->

                        <xsl:otherwise>
                          <table class="tbl-horizontal">
                            <xsl:apply-templates select="RESPONSES" mode="tabular_horizontal"/>
                          </table>
                        </xsl:otherwise>
                      </xsl:choose>

                    </xsl:otherwise>
                  </xsl:choose>
                </div>
              </xsl:for-each>
            </div>
          </div>
        </xsl:for-each>
      </div>
    </xsl:for-each>

  </xsl:template>

  <!-- template for vertical tabular responses -->
  <xsl:template match="RESPONSES">
    <xsl:for-each select="RESPONSE">
      <li>
        <xsl:choose>
          <!-- Render Radio buttons -->
          <xsl:when test="DISPLAY_TYPE = 1">
            <label>
              <input type="radio" id="rid_{RID}" rid="{RID}" name="grpRadio_{RESPONSE_GROUP}_{MID}_{TID}_{QID}" value="{RESPONSE_PLAIN}|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>&#160;<xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
            </label>
          </xsl:when>
          <!-- Render Check boxes -->
          <xsl:when test="DISPLAY_TYPE = 2">
            <label>
              <input type="checkbox" id="rid_{RID}" rid="{RID}" name="grpCheck_{RESPONSE_GROUP}_{MID}_{TID}_{QID}" value="{RESPONSE_CHECKBOX}|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>&#160;<xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
            </label>
          </xsl:when>
          <!-- Render Text box -->
          <xsl:when test="DISPLAY_TYPE = 3">

            <xsl:choose>
              <xsl:when test="MAXLENGTH &gt; 100">
                <label style="width:100%;">
                  <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
                  <br/>
                  <textarea id="rid_txt_{RID}" rid="{RID}" name="grpCtrlText_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" maxlength="{MAXLENGTH}" rows="4" style="width: 95%;"></textarea>
                </label>
              </xsl:when>
              <xsl:otherwise>
                <label>
                  <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>&#160;<input type="text" id="rid_txt_{RID}" rid="{RID}" name="grpCtrlText_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" maxlength="{MAXLENGTH}" size="{MAXLENGTH}" />&#160;<xsl:value-of select="UNIT"/>
                </label>
              </xsl:otherwise>
            </xsl:choose>

            <input type="hidden" name="DISABLED_grpHidden_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" id="rid_{RID}" rid="{RID}" value="|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}|{UNIT}"/>
          </xsl:when>
          <!-- Render Datepicker control -->
          <xsl:when test="DISPLAY_TYPE = 21">
            <label>
              <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>&#160;
              <input type="text" class="datepicker" id="rid_txt_{RID}" rid="{RID}" name="grpCtrlText_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" maxlength="{MAXLENGTH}" size="{MAXLENGTH}" />
              &#160;<xsl:value-of select="UNIT"/>
            </label>
            <input type="hidden" name="DISABLED_grpHidden_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" id="rid_{RID}" rid="{RID}" value="|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>
          </xsl:when>
          <!-- Render Combo boxes -->
          <xsl:when test="DISPLAY_TYPE = 4">
            <label>
              <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes" />
            </label>&#160;<select id="rid_{RID}" rid="{RID}" name="grpSelect_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" >
              <option value=""></option>
              <xsl:apply-templates select="OPTIONS"/>
            </select>
          </xsl:when>
          <!-- Render Sliders -->
          <xsl:when test="DISPLAY_TYPE = 22">
            <table style="border-collapse: collapse; width: auto;">
              <tr>
                <td colspan="2">
                  <label>
                    <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes" />
                  </label>
                </td>
              </tr>
              <tr>
                <td style="width: 310px;">
                  <div class="slide-container">
                    <div id="divSlider_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" sliderfor="grpSelect_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" style="width: 300px;"></div>
                    <div style="width: 300px;">
                      <div style="float:left; width: 40%; text-align: left;">
                        <span style="font-size: 10px;"></span>
                      </div>
                      <div style="float:right; width: 40%; text-align: right;">
                        <span style="font-size: 10px;"></span>
                      </div>
                    </div>
                  </div>
                </td>
                <td style="padding-left: 10px;">
                  <select id="rid_{RID}" rid="{RID}" name="grpSelect_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" class="combo-slider">
                    <option value=""></option>
                    <xsl:apply-templates select="OPTIONS"/>
                  </select>
                </td>
              </tr>
            </table>
          </xsl:when>
          <!-- Render Title -->
          <xsl:when test="DISPLAY_TYPE = 11">
            <div id="rid_{RID}">
              <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes" />
              <input type="hidden" id="rid_{RID}" rid="{RID}" name="grpTitle_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" value="{RESPONSE_PLAIN}" />
            </div>
          </xsl:when>
          <!-- Render 'None of the above' Check boxes -->
          <xsl:when test="DISPLAY_TYPE = 99">
            <label>
              <input type="checkbox" id="rid_{RID}" rid="{RID}" name="grpCheck_{RESPONSE_GROUP}_{MID}_{TID}_{QID}" clearabove="clearabove" value="{RESPONSE_TEXT}|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>&#160;<xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
            </label>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes" />
          </xsl:otherwise>
        </xsl:choose>
      </li>
    </xsl:for-each>
  </xsl:template>

  <!-- template for horizontal tabular responses -->
  <xsl:template match="RESPONSES" mode="tabular_horizontal">
    <xsl:for-each select="RESPONSE">
      <td>
        <xsl:choose>
          <!-- Render Radio buttons -->
          <xsl:when test="DISPLAY_TYPE = 1">
            <label>
              <input type="radio" id="rid_{RID}" rid="{RID}" name="grpRadio_{RESPONSE_GROUP}_{MID}_{TID}_{QID}" value="{RESPONSE_PLAIN}|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>&#160;<xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
            </label>
          </xsl:when>
          <!-- Render Check boxes -->
          <xsl:when test="DISPLAY_TYPE = 2">
            <label>
              <input type="checkbox" id="rid_{RID}" rid="{RID}" name="grpCheck_{RESPONSE_GROUP}_{MID}_{TID}_{QID}" value="{RESPONSE_CHECKBOX}|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>&#160;<xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
            </label>
          </xsl:when>
          <!-- Render Text box -->
          <xsl:when test="DISPLAY_TYPE = 3">
            <xsl:choose>
              <xsl:when test="MAXLENGTH &gt; 100">
                <label style="width:100%;">
                  <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
                  <br/>
                  <textarea id="rid_txt_{RID}" rid="{RID}" name="grpCtrlText_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" maxlength="{MAXLENGTH}" rows="4" style="width: 95%;"></textarea>
                </label>
              </xsl:when>
              <xsl:otherwise>
                <label>
                  <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>&#160;<input type="text" id="rid_txt_{RID}" rid="{RID}" name="grpCtrlText_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" maxlength="{MAXLENGTH}" size="{MAXLENGTH}" />&#160;<xsl:value-of select="UNIT"/>
                </label>
              </xsl:otherwise>
            </xsl:choose>
            <input type="hidden" name="DISABLED_grpHidden_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" id="rid_{RID}" rid="{RID}" value="|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>
          </xsl:when>
          <!-- Render Datepicker control -->
          <xsl:when test="DISPLAY_TYPE = 21">
            <label>
              <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>&#160;
              <input type="text" class="datepicker" id="rid_txt_{RID}" rid="{RID}" name="grpCtrlText_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" maxlength="{MAXLENGTH}" size="{MAXLENGTH}" />
              &#160;<xsl:value-of select="UNIT"/>
            </label>
            <input type="hidden" name="DISABLED_grpHidden_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" id="rid_{RID}" rid="{RID}" value="|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>
          </xsl:when>
          <!-- Render Combo boxes -->
          <xsl:when test="DISPLAY_TYPE = 4">
            <label>
              <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes" />
            </label>&#160;<select id="rid_{RID}" rid="{RID}" name="grpSelect_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" >
              <option value=""></option>
              <xsl:apply-templates select="OPTIONS"/>
            </select>
          </xsl:when>
          <!-- Render Combo/Sliders -->
          <xsl:when test="DISPLAY_TYPE = 22">
            <table style="border-collapse: collapse; width: auto;">
              <tr>
                <td colspan="2">
                  <label>
                    <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes" />
                  </label>
                </td>
              </tr>
              <tr>
                <td style="width: 310px;">
                  <div class="slide-container">
                    <div id="divSlider_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" sliderfor="grpSelect_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" style="width: 300px;"></div>
                    <div style="width: 300px;">
                      <div style="float:left; width: 40%; text-align: left;">
                        <span style="font-size: 10px;"></span>
                      </div>
                      <div style="float:right; width: 40%; text-align: right;">
                        <span style="font-size: 10px;"></span>
                      </div>
                    </div>
                  </div>
                </td>
                <td style="padding-left: 10px;">
                  <select id="rid_{RID}" rid="{RID}" name="grpSelect_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" class="combo-slider">
                    <option value=""></option>
                    <xsl:apply-templates select="OPTIONS"/>
                  </select>
                </td>
              </tr>
            </table>
          </xsl:when>
          <!-- Render Title -->
          <xsl:when test="DISPLAY_TYPE = 11">
            <div id="rid_{RID}">
              <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes" />
            </div>
          </xsl:when>
          <!-- Render 'None of the above' Check boxes -->
          <xsl:when test="DISPLAY_TYPE = 99">
            <label>
              <input type="checkbox" id="rid_{RID}" rid="{RID}" name="grpCheck_{RESPONSE_GROUP}_{MID}_{TID}_{QID}" clearabove="clearabove" value="{RESPONSE_TEXT}|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>&#160;<xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
            </label>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </xsl:for-each>
  </xsl:template>

  <!-- template for vertical tabular responses -->
  <xsl:template match="RESPONSES" mode="tabular_vertical">
    <xsl:for-each select="RESPONSE">
      <tr>
        <td>
          <xsl:choose>
            <!-- Render Radio buttons -->
            <xsl:when test="DISPLAY_TYPE = 1">
              <label>
                <input type="radio" id="rid_{RID}" rid="{RID}" name="grpRadio_{RESPONSE_GROUP}_{MID}_{TID}_{QID}" value="{RESPONSE_PLAIN}|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>&#160;<xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
              </label>
            </xsl:when>
            <!-- Render Check boxes -->
            <xsl:when test="DISPLAY_TYPE = 2">
              <label>
                <input type="checkbox" id="rid_{RID}" rid="{RID}" name="grpCheck_{RESPONSE_GROUP}_{MID}_{TID}_{QID}" value="{RESPONSE_CHECKBOX}|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>&#160;<xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
              </label>
            </xsl:when>
            <!-- Render Text box -->
            <xsl:when test="DISPLAY_TYPE = 3">
              <xsl:choose>
                <xsl:when test="MAXLENGTH &gt; 100">
                  <label style="width:100%;">
                    <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
                    <br/>
                    <textarea id="rid_txt_{RID}" rid="{RID}" name="grpCtrlText_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" maxlength="{MAXLENGTH}" rows="4" style="width: 95%;"></textarea>
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>&#160;<input type="text" id="rid_txt_{RID}" rid="{RID}" name="grpCtrlText_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" maxlength="{MAXLENGTH}" size="{MAXLENGTH}" />&#160;<xsl:value-of select="UNIT"/>
                  </label>
                </xsl:otherwise>
              </xsl:choose>
              <input type="hidden" name="DISABLED_grpHidden_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" id="rid_{RID}" rid="{RID}" value="|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>
            </xsl:when>
            <!-- Render Datepicker control -->
            <xsl:when test="DISPLAY_TYPE = 21">
              <label>
                <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>&#160;
                <input type="text" class="datepicker" id="rid_txt_{RID}" rid="{RID}" name="grpCtrlText_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" maxlength="{MAXLENGTH}" size="{MAXLENGTH}" />
                &#160;<xsl:value-of select="UNIT"/>
              </label>
              <input type="hidden" name="DISABLED_grpHidden_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" id="rid_{RID}" rid="{RID}" value="|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>
            </xsl:when>
            <!-- Render Combo boxes -->
            <xsl:when test="DISPLAY_TYPE = 4">
              <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes" />&#160;<select id="rid_{RID}" rid="{RID}" name="grpSelect_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" >
                <xsl:apply-templates select="OPTIONS"/>
              </select>
            </xsl:when>
            <!-- Render Combo/Sliders -->
            <xsl:when test="DISPLAY_TYPE = 22">
              <table style="border-collapse: collapse; width: auto;">
                <tr>
                  <td colspan="2">
                    <label>
                      <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes" />
                    </label>
                  </td>
                </tr>
                <tr>
                  <td style="width: 310px;">
                    <div class="slide-container">
                      <div id="divSlider_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" sliderfor="grpSelect_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" style="width: 300px;"></div>
                      <div style="width: 300px;">
                        <div style="float:left; width: 40%; text-align: left;">
                          <span style="font-size: 10px;"></span>
                        </div>
                        <div style="float:right; width: 40%; text-align: right;">
                          <span style="font-size: 10px;"></span>
                        </div>
                      </div>
                    </div>
                  </td>
                  <td style="padding-left: 10px;">
                    <select id="rid_{RID}" rid="{RID}" name="grpSelect_{RESPONSE_GROUP}_{MID}_{TID}_{QID}_{RID}_{RESPONSE_TYPE}_{IDENTIFIER}" class="combo-slider">
                      <option value=""></option>
                      <xsl:apply-templates select="OPTIONS"/>
                    </select>
                  </td>
                </tr>
              </table>
            </xsl:when>
            <!-- Render Title -->
            <xsl:when test="DISPLAY_TYPE = 11">
              <div id="rid_{RID}">
                <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes" />
              </div>
            </xsl:when>
            <!-- Render 'None of the above' Check boxes -->
            <xsl:when test="DISPLAY_TYPE = 99">
              <label>
                <input type="checkbox" id="rid_{RID}" rid="{RID}" name="grpCheck_{RESPONSE_GROUP}_{MID}_{TID}_{QID}" clearabove="clearabove" value="{RESPONSE_TEXT}|{RID}|{SCORE_VALUE}|{RESPONSE_TYPE}|{IDENTIFIER}"/>&#160;<xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
              </label>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="RESPONSE_TEXT/node()" disable-output-escaping="yes"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </xsl:for-each>
  </xsl:template>

  <!-- template for combo options -->
  <xsl:template match="OPTIONS">
    <xsl:for-each select="OPTION">
      <option value="{DATA_VALUE}|{SCORE_VALUE}">
        <xsl:value-of select="DATA_VALUE"/>
      </option>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>